import React, { useState } from 'react';
import { Pressable, View, Image } from 'react-native';
import { itemCarouselStyle } from './ItemCarouselStyle';
import CustomPhotoGallery from '../../../../../src/components/CustomImageGallery/CustomPhotoGallery';
import { singleProductStyle } from '../../../../../src/components/SingleProduct/singleProduct.style';
import ProductBadge from '../../../../../src/components/SingleProduct/ProductBadge';

const SingleImage = ({
    item,
    index,
    data,
    setCurrentSlideIndex,
    productBadge
}) => {
    const [isOpen, setIsOpen] = useState(false);
    const {
        isOutOfStock,
        featured,
        offerCheck,
        discountPercent,
        review_average,
    } = productBadge || {};
    const preview = Image.resolveAssetSource(require("../../../../../assets/images/image-loader-icon.png")).uri
    ;
    return (
        <>
            <Pressable
                style={itemCarouselStyle.singleImgCont}
                onPress={() => setIsOpen(true)}
            >
                <View style={singleProductStyle.offerBadge}>
                    <ProductBadge
                        data={{
                            isOutOfStock,
                            featured,
                            offerCheck,
                            discountPercent,
                            review_average,
                        }}
                    />
                </View>
                {item ? <Image 
                    source={{
                        uri: item,
                    }}
                    style={itemCarouselStyle.imageSize} 
                /> : <Image 
                source={{
                    uri: preview,
                }}
                style={itemCarouselStyle.imageSize} 
            />}
            </Pressable>
            <CustomPhotoGallery
                isOpen={isOpen}
                setIsOpen={setIsOpen}
                images={data}
                index={index}
                setCurrentSlideIndex={setCurrentSlideIndex}
            />
        </>
    );
};

export default SingleImage;
